/* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR REPRESENTATIONS,
 * EITHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING ANY IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY
 * OR COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE. TI DISCLAIMS
 * ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET POSSESSION, AND NON-INFRINGEMENT
 * OF ANY THIRD PARTY INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR
 * YOUR USE OF THE PROGRAM.
 * IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL, CONSEQUENTIAL OR
 * INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY THEORY OF LIABILITY AND WHETHER OR
 * NOT TI HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY
 * OUT OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.  EXCLUDED
 * DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF REMOVAL OR REINSTALLATION,
 * COMPUTER TIME, LABOR COSTS, LOSS OF GOODWILL, LOSS OF PROFITS, LOSS OF
 * SAVINGS, OR LOSS OF USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S
 * AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF YOUR USE OF THE
 * PROGRAM EXCEED FIVE HUNDRED DOLLARS (U.S.$500).
 * Unless otherwise stated, the Program written and copyrighted by Texas
 * Instruments is distributed as "freeware".  You may, only under TI's copyright
 * in the Program, use and modify the Program without any charge or restriction.
 * You may distribute to third parties, provided that you transfer a copy of this
 * license to the third party and the third party agrees to these terms by its
 * first use of the Program. You must reproduce the copyright notice and any
 * other legend of ownership on each copy or partial copy, of the Program.
 * You acknowledge and agree that the Program contains copyrighted material,
 * trade secrets and other TI proprietary information and is protected by
 * copyright laws, international copyright treaties, and trade secret laws, as
 * well as other intellectual property laws.  To protect TI's rights in the
 * Program, you agree not to decompile, reverse engineer, disassemble or
 * otherwise translate any object code versions of the Program to a
 * human-readable form.  You agree that in no event will you alter, remove or
 * destroy any copyright notice included in the Program.  TI reserves all rights
 * not specifically granted under this license. Except as specifically provided
 * herein, nothing in this agreement shall be construed as conferring by
 * implication, estoppel, or otherwise, upon you, any license or other right
 * under any TI patents, copyrights or trade secrets.
 * You may not use the Program in non-TI devices. */


//******************************************************************************
//
//  main.h
//  Main function
//
//  Matthias Ulmann, Design Services - EMEA Power Management
//  Texas Instruments, Inc.
//
//******************************************************************************


#ifndef MAIN_H_
#define MAIN_H_


#include <msp430F2252.h>
#include <string.h>
#include "init.h"
#include "lcd.h"
#include "switch.h"
#include "adc.h"
#include "timerB.h"
#include "timerA.h"
#include "i2c.h"
#include "menu.h"
#include "flash.h"


#define XTAL 16000000	// clock frequency in Hz to calculate delays
#define delay_us(us)	__delay_cycles( (XTAL/1000000) *us)
#define delay_ms(ms)	__delay_cycles( (XTAL/1000) *ms)



//******************************************************************************
// some useful macros
//******************************************************************************

// clear bit
#ifndef clear_bit
#define clear_bit(port, bit)	( port &= ~(bit) )
#endif

// set bit
#ifndef set_bit
#define set_bit(port, bit)		( port |= (bit))
#endif

// toggle bit
#ifndef toggle_bit
#define toggle_bit(port, bit)	( port ^= (bit))
#endif



//******************************************************************************
// definitions for the LCD backlight
//******************************************************************************

// bit for LCD backlight
#define BLIGHT_BIT		BIT0

// function select register for LCD backlight
#define BLIGHT_PSEL		P1SEL

// direction register for LCD backlight
#define BLIGHT_PDIR		P1DIR

// output register for LCD backlight
#define BLIGHT_POUT		P1OUT

// input register for LCD backlight
#define BLIGHT_PIN		P1IN

// pullup/-down resistor register for LCD backlight
#define BLIGHT_RES		P1REN



//******************************************************************************
// switch LCD backlight on/off
//******************************************************************************

// switch LCD backlight on
#define BLIGHT_on		set_bit(BLIGHT_POUT, BLIGHT_BIT)

// switch LCD backlight off
#define BLIGHT_off		clear_bit(BLIGHT_POUT, BLIGHT_BIT)



//******************************************************************************
// definitions for the LED
//******************************************************************************

// bit for LED
#define LED_BIT			BIT6

// function select register for LED
#define LED_PSEL		P4SEL

// direction register for LED
#define LED_PDIR		P4DIR

// output register for LED
#define LED_POUT		P4OUT

// input register for LED
#define LED_PIN			P4IN

// pullup/-down resistor register for LED
#define LED_RES			P4REN



//******************************************************************************
// switch LED on/off
//******************************************************************************

// switch LED on
#define LED_on			clear_bit(LED_POUT, LED_BIT)

// switch LED off
#define LED_off			set_bit(LED_POUT, LED_BIT)



//******************************************************************************
// definitions for the enable output
//******************************************************************************

// bit for enable
#define ENABLE_BIT		BIT7

// function select register for enable
#define ENABLE_PSEL		P4SEL

// direction register for enable
#define ENABLE_PDIR		P4DIR

// output register for enable
#define ENABLE_POUT		P4OUT

// input register for LEDenable
#define ENABLE_PIN		P4IN

// pullup/-down resistor register for enable
#define ENABLE_RES		P4REN



//******************************************************************************
// enable/disable power supply
//******************************************************************************

// enable power supply
#define POWER_on		clear_bit(ENABLE_POUT, ENABLE_BIT)

// disable power supply
#define POWER_off		set_bit(ENABLE_POUT, ENABLE_BIT)


#endif /*MAIN_H*/
